<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2023. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Jextboxarticleautomanager model.
 */
class JextboxarticleautomanagerModelOperation extends Joomla\CMS\MVC\Model\AdminModel
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since	1.6
	 */
	protected $text_prefix = 'COM_JEXTBOXARTICLEAUTOMANAGER';

	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 * @return	JTable	A database object
	 * @since	1.6
	 */
	public function getTable($type = 'Operation', $prefix = 'JextboxarticleautomanagerTable', $config = array())
	{
		return Joomla\CMS\Table\Table::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		An optional array of data for the form to interogate.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	JForm	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		// Get the form.
		$form = $this->loadForm('com_jextboxarticleautomanager.operation', 'operation', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form)) {
			return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return	mixed	The data for the form.
	 * @since	1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = Joomla\CMS\Factory::getApplication()->getUserState('com_jextboxarticleautomanager.edit.operation.data', array());

		if (empty($data)) {
			$data = $this->getItem();
		}

		return $data;
	}

	/**
	 * Method to get a single record.
	 *
	 * @param	integer	The id of the primary key.
	 *
	 * @return	mixed	Object on success, false on failure.
	 * @since	1.6
	 */
	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk)) {

			//Do any procesing on fields here if needed

		}

		return $item;
	}

	/**
	 * Prepare and sanitise the table prior to saving.
	 *
	 * @since	1.6
	 */
	protected function prepareTable($table)
	{
		jimport('joomla.operation.output');
		if (empty($table->id)) {
			// Set ordering to the last item if not set
			if (@$table->ordering === '') {
				$db = Joomla\CMS\Factory::getDbo();
				$db->setQuery('SELECT MAX(ordering) FROM #__jextboxarticleautomanager');
				$max = $db->loadResult();
				$table->ordering = $max+1;
			}
		}
	}

	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.6
	 */
	public function save ($data)
	{
		// Name
		if (empty($data['name']))
		{
			$data['name'] = 'Untitled';
		}
		// Extend publish down
		if ($data['operation'] == 5 && (intval($data['extend_number']) != $data['extend_number'] || $data['extend_number'] < 0))
		{
			$data['extend_number'] = 0;
		}
		// Correct day
		if ($data['execution_period'] == 4) {
			switch (true) {
				case in_array($data['execution_month'], array(4,6,9,11)) :
					$data['execution_month_day'] = min(30, $data['execution_month_day']);
					break;
				case $data['execution_month'] == 2 :
					$data['execution_month_day'] = min(29, $data['execution_month_day']);
					break;
			}
		}
		// Created by
		if (empty($data['created_by']))
		{
			$user = version_compare(JVERSION, '5.0.0', '<') ? Joomla\CMS\Factory::getUser() : Joomla\CMS\Factory::getApplication()->getIdentity();
			$data['created_by'] = $user->id;
		}
		//
		$data['query_sql'] = urldecode($data['query_sql']);
		return parent::save($data);
	}

}

?>
