<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2023. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * View class for a list of Jextboxarticleautomanager.
 */
class JextboxarticleautomanagerViewAbout extends Joomla\CMS\MVC\View\HtmlView
{

	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state = $this->get('State');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}

		if (version_compare(JVERSION, '4.0.0', '<'))
		{
			JextboxarticleautomanagerHelper::addSubmenu('about');
			$this->sidebar = JHtmlSidebar::render();
		}

		$this->addToolbar();

		parent::display($tpl);

	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/jextboxarticleautomanager.php';

		$state = $this->get('State');
		$canDo = JextboxarticleautomanagerHelper::getActions($state->get('filter.category_id'));

		JToolBarHelper::title(Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_TITLE_ABOUT').' '.Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER'), 'info');

		if ($canDo->get('core.admin')) {
			JToolBarHelper::preferences('com_jextboxarticleautomanager');
		}

		//Set sidebar action - New in 3.0
		if (version_compare(JVERSION, '4.0.0', '<')) {
			JHtmlSidebar::setAction('index.php?option=com_jextboxarticleautomanager&view=about');
		} else {
			Joomla\CMS\HTML\Helpers\Sidebar::setAction('index.php?option=com_jextboxarticleautomanager&view=about');
		}

		$this->extra_sidebar = '';
	}

	protected function getSortFields()
	{
		return array();
	}

}

?>
