<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2023. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('JPATH_BASE') or die('Restricted access');

class JFormFieldCreatedby extends Joomla\CMS\Form\FormField
{

	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'createdby';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{

		// Initialize variables.
		$html = array();

		//Load user
		$user_id = $this->value;
		if ($user_id) {
			$user = version_compare(JVERSION, '5.0.0', '<') ? Joomla\CMS\Factory::getUser($user_id) : Joomla\CMS\Factory::getApplication()->getIdentity($user_id);
		} else {
			$user = version_compare(JVERSION, '5.0.0', '<') ? Joomla\CMS\Factory::getUser() : Joomla\CMS\Factory::getApplication()->getIdentity();
			$html[] = '<input type="hidden" name="'.$this->name.'" value="'.$user->id.'" />';
		}
		$html[] = '<div>'.$user->name.' ('.$user->username.')</div>';

		return implode($html);

	}

}

?>
