<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2023. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('JPATH_BASE') or die('Restricted access');

/**
 * Supports an HTML select list of categories
 */
class JFormFieldTimeupdated extends Joomla\CMS\Form\FormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'timeupdated';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		// Initialize variables.
		$html = array();

		$old_time_updated = $this->value;
		$hidden = (boolean) $this->element['hidden'];
		if ($hidden == null || !$hidden){
			if (!strtotime($old_time_updated)) {
				$html[] = '-';
			} else {
				$jdate = new Joomla\CMS\Date\Date($old_time_updated);
				$pretty_date = $jdate->format(Joomla\CMS\Language\Text::_('DATE_FORMAT_LC2'));
				$html[] = '<div>'.$pretty_date.'</div>';
			}
		}
		$time_updated = date('Y-m-d H:i:s');
		$html[] = '<input type="hidden" name="'.$this->name.'" value="'.$time_updated.'" />';

		return implode($html);
	}

}

?>
