<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2021-2023. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Script file of JExtBOX Article Auto Manager component.
 *
 * The name of this class is dependent on the component being installed.
 * The class name should have the component's name, directly followed by
 * the text InstallerScript (ex:. com_jextboxarticleautomanagerInstallerScript).
 *
 * This class will be called by Joomla!'s installer, if specified in your component's
 * manifest file, and is used for custom automation actions in its installation process.
 *
 * In order to use this automation script, you should reference it in your component's
 * manifest file as follows:
 * <scriptfile>script.php</scriptfile>
 *
 */
class com_jextboxarticleautomanagerInstallerScript
{

	public function update($parent) 
	{

		$db = Joomla\CMS\Factory::getDbo();
		$db->setQuery('DESCRIBE ' . $db->quoteName('#__jextboxarticleautomanager'));
		$column_names = $db->loadAssocList(null, 'Field');
		if (!in_array('extend_number', $column_names)) {
			$db->setQuery('ALTER TABLE `#__jextboxarticleautomanager` ADD `extend_number` INT UNSIGNED NOT NULL AFTER `new_access_level`, ADD `extend_interval` TINYINT UNSIGNED NOT NULL AFTER `extend_number`');
			$db->execute();
		}

	}

}

?>
