<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2024. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

Joomla\CMS\HTML\HTMLHelper::addIncludePath(JPATH_COMPONENT.'/helpers/html');
Joomla\CMS\HTML\HTMLHelper::_('bootstrap.tooltip');

// Import CSS
$document = Joomla\CMS\Factory::getDocument();
$document->addStyleSheet('components/com_jextboxarticleautomanager/assets/css/jextboxarticleautomanager.css');

?>

<?php
if (!empty($this->extra_sidebar)) {
	$this->sidebar .= $this->extra_sidebar;
}
?>

<?php if(!empty($this->sidebar)): ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
<?php else : ?>
	<div id="j-main-container">
<?php endif;?>
		<div>
			<dl class="dl-horizontal">
				<dt>Name</dt>
				<dd>JExtBOX Article Auto Manager</dd>
				<dt>Features</dt>
				<dd>This package (component + plugin) manages your articles automatically or manually:
					<ul>
						<li>Archive</li>
						<li>Unpublish</li>
						<li>Publish</li>
						<li>Move to Trash</li>
						<li>Move to Another Category</li>
						<li>Assign or remove the Featured status</li>
						<li>Change Access Level</li>
						<li>Extend Publish Down</li>
					</ul>
				</dd>
				<dt>Version</dt>
				<dd>
					<?php
						$xml = simplexml_load_file(JPATH_ADMINISTRATOR.'/components/com_jextboxarticleautomanager/jextboxarticleautomanager.xml');
						echo (string)$xml->version;
					?>
				</dd>
				<dt>Web Page</dt>
				<dd><a href="https://www.jextbox.com/extension/152" target="_blank">www.jextbox.com/extension/152</a></dd>
			</dl>
		</div>
		<div class="text-center">
			Copyright (C) 2011-2024 <a href="https://www.galaa.net" target="_blank">Galaa</a>. Distributed by <a href="https://www.jextbox.com" target="_blank">JExtBOX - BOX of Joomla Extensions</a>
		</div>
		<div class="clearfix"> </div>
	</div>
