<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2024. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

Joomla\CMS\HTML\HTMLHelper::_('jquery.framework');

Joomla\CMS\HTML\HTMLHelper::addIncludePath(JPATH_COMPONENT . '/helpers/html');
Joomla\CMS\HTML\HTMLHelper::_('behavior.formvalidator');
if ($j3 = version_compare(JVERSION, '4.0.0', '<'))
{
	Joomla\CMS\HTML\HTMLHelper::_('bootstrap.tooltip', '.hasTooltip', ['placement' => 'auto-dir bottom-left']);
	Joomla\CMS\HTML\HTMLHelper::_('formbehavior.chosen', 'select');
}
Joomla\CMS\HTML\HTMLHelper::_('behavior.keepalive');

// Import CSS
$document = Joomla\CMS\Factory::getDocument();
$document->addStyleSheet('components/com_jextboxarticleautomanager/assets/query-builder/css/query-builder.default.min.css');
$document->addStyleSheet('components/com_jextboxarticleautomanager/assets/css/jextboxarticleautomanager.css');

// Import JS
$document->addScript('components/com_jextboxarticleautomanager/assets/query-builder/js/query-builder.standalone.min.js');

$queryBuilderFilters = new StdClass;

// Category
$db = Joomla\CMS\Factory::getDbo();
$query = $db->getQuery(true)
	->select($db->qn(array('c2.id', 'c2.level', 'c2.title')))
	->from($db->qn('#__categories', 'c1'))
	->join('INNER', $db->qn('#__categories', 'c2') . ' ON ' . $db->qn('c1.id') . ' = ' . $db->qn('c2.parent_id'))
	->where($db->qn('c2.extension') . '=' . $db->q('com_content'))
	->where($db->qn('c2.published') . '=' . $db->q('1'))
	->order($db->qn('c2.lft') . ' ASC');
$db->setQuery($query);
$categories = $db->loadObjectList();
foreach ($categories as &$category)
	$category = (object) array('value' => $category->id, 'label' => str_repeat('- ', $category->level - 1).$category->title);
unset($category);
$queryBuilderFilters->category = json_encode($categories);

// ACL
$db = Joomla\CMS\Factory::getDbo();
$query = $db->getQuery(true)
	->select($db->qn(array('id', 'title')))
	->from($db->qn('#__viewlevels'))
	->order($db->qn('ordering') . ' ASC');
$db->setQuery($query);
$queryBuilderFilters->acl = json_encode($db->loadAssocList('id', 'title'));

// Get query or current condition
$fieldset = $this->form->getFieldset();
$query = $fieldset['jform_query']->value;

?>
<script type="text/javascript">
	js = jQuery.noConflict();
	js(document).ready(function(){
		js('#builder').queryBuilder({
			filters: [{
				id: 'age_created', label: 'Age in days from the Created date', type: 'integer', input: 'number', validation: {min: '1', step: '1'}, operators: ['greater', 'less']
			},{
				id: 'age_publish_up', label: 'Age in days from the Published date', type: 'integer', input: 'number', validation: {min: '1', step: '1'}, operators: ['greater', 'less']
			},{
				id: 'hits', label: 'Hits', type: 'integer', input: 'number', validation: {min: '1', step: '1'}, operators: ['greater', 'less']
			},{
				id: 'category', label: 'Category', type: 'integer', input: 'select', multiple: 'true', values: <?php echo $queryBuilderFilters->category; ?>, operators: ['in', 'not_in']
			},{
				id: 'featured', label: 'Featured', type: 'integer', input: 'radio', values: {'1': 'Yes', '0': 'No'}, operators: ['equal', 'not_equal']
			},{
				id: 'access', label: 'Access Level', type: 'integer', input: 'select', values: <?php echo $queryBuilderFilters->acl; ?>, operators: ['equal', 'not_equal']
			},{
				id: 'state', label: 'State', type: 'integer', input: 'select', values: {'1': 'Published', '0': 'Unpublished', '2': 'Archived', '-2': 'Trashed'}, operators: ['equal', 'not_equal']
			},{
				id: 'published_down', label: 'Published Down', type: 'integer', input: 'radio', values: {'1': 'Yes', '0': 'No', '-1': 'NULL'}, operators: ['equal', 'not_equal']
			}]<?php if (!empty($query)) : ?>,
			rules : <?php echo $query; ?><?php endif; ?>
		});
	});

	Joomla.submitbutton = function(task) {
		if (task == 'operation.cancel') {
			Joomla.submitform(task, document.getElementById('operation-form'));
		} else {
			if (task != 'operation.cancel' && document.formvalidator.isValid(document.getElementById('operation-form'))) {
				if (js('#builder').queryBuilder('validate')) {
					var query = JSON.stringify(js('#builder').queryBuilder('getRules'), null, 2);
					js('#jform_query').val(query);
					query = js('#builder').queryBuilder('getSQL', 'named');
					js('#jform_query_sql').val(encodeURI(query.sql));
					js('#jform_query_params').val(JSON.stringify(query.params, null, 2));
					Joomla.submitform(task, document.getElementById('operation-form'));
				} else {
					alert('Invalid field: Condition');
				}
			}
		}
	}
</script>

<form action="<?php echo Joomla\CMS\Router\Route::_('index.php?option=com_jextboxarticleautomanager&layout=edit&id=' . (int) $this->item->id); ?>" method="post" enctype="multipart/form-data" name="adminForm" id="operation-form" class="form-validate">
	<div class="<?php echo $j3 ? 'row-fluid' : 'row' ?>">
		<div class="<?php echo $j3 ? 'span8' : 'col-xl-8' ?>">
			<?php if ($j3) : ?><div class="form-inline form-inline-header"><?php endif; ?>
				<?php echo $this->form->renderFieldset('operation_name'); ?>
			<?php if ($j3) : ?></div><?php endif; ?>
			<?php echo Joomla\CMS\HTML\HTMLHelper::_('bootstrap.startTabSet', 'AAM_Tab', array('active' => 'query_settings')); ?>
				<?php echo Joomla\CMS\HTML\HTMLHelper::_('bootstrap.addTab', 'AAM_Tab', 'query_settings', Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_TAB_LBL_QUERY', true)); ?>
					<div class="form-horizontal<?php if (!$j3) echo ' mt-4'; ?>">
						<?php echo $this->form->renderFieldset('operation_settings'); ?>
						<div class="control-group">
							<div id="builder"></div>
						</div>
					</div>
					<p><?php echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_NOTICE_FOR_FREE_VERSION_CONDITION', true); ?></p>
					<?php echo $this->form->renderFieldset('leaving_settings'); ?>
				<?php echo Joomla\CMS\HTML\HTMLHelper::_('bootstrap.endTab'); ?>
				<?php echo Joomla\CMS\HTML\HTMLHelper::_('bootstrap.addTab', 'AAM_Tab', 'execution_settings', Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_TAB_LBL_EXECUTION', true)); ?>
					<div class="form-horizontal<?php if (!$j3) echo ' mt-4'; ?>">
						<p><strong><?php echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_PRINCIPAL_EXECUTION_METHOD', true); ?></strong></p>
						<p><?php echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_PRINCIPAL_EXECUTION_METHOD_DSC', true); ?></p>
						<?php echo $this->form->renderFieldset('execution_settings'); ?>
					</div>
					<div class="form-horizontal<?php if (!$j3) echo ' mt-4'; ?>">
						<p><strong><?php echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_ADDITIONAL_EXECUTION_METHOD', true); ?></strong></p>
						<p><?php echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_NOTICE_FOR_FREE_VERSION_EXECUTION', true); ?></p>
						<p><?php echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_ADDITIONAL_EXECUTION_METHOD_DSC', true); ?></p>
					</div>
				<?php echo Joomla\CMS\HTML\HTMLHelper::_('bootstrap.endTab'); ?>
			<?php echo Joomla\CMS\HTML\HTMLHelper::_('bootstrap.endTabSet'); ?>
		</div>
		<div class="<?php echo $j3 ? 'span4' : 'col-xl-4' ?> aam_sidebar">
			<?php echo $this->form->renderFieldset('meta'); ?>
			<hr />
			<h5>Difference between free and full versions</h5>
			<p>There are no visible differences between free and paid versions. However, you can observe the following differences in real-life usage.</p>
			<ul>
				<li>Package Configurations
					<ul>
						<li>Article restriction for excluding specific articles from accidental change</li>
						<li>The upper limit on the number of automatically executed operations at once to avoid enormously high loading on a single request</li>
						<li>The particular parameter for stopping all operations temporarily</li>
					</ul>
				</li>
				<li>Conditions
					<ul>
						<li>The additional filter to prevent emptying a category and the front page</li>
					</ul>
				</li>
				<li>Execution
					<ul>
						<li>Manual execution in the back-end and the front-end</li>
						<li>Ability to connect cron job or Joomla Scheduled Tasks</li>
					</ul>
				</li>
			</ul>
			<input type="hidden" name="task" value="" />
			<?php echo Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
		</div>
	</div>
</form>
<div class="text-center">
	Copyright (C) 2011-2024 <a href="https://www.galaa.net" target="_blank">Galaa</a>. Distributed by <a href="https://www.jextbox.com" target="_blank">JExtBOX - BOX of Joomla Extensions</a>
</div>
