<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2023. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * View to edit
 */
class JextboxarticleautomanagerViewOperation extends Joomla\CMS\MVC\View\HtmlView
{
	protected $state;
	protected $item;
	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{

		$db = Joomla\CMS\Factory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select('COUNT(*)')
			->from($db->quoteName('#__extensions'))
			->where($db->quoteName('element')." = ".$db->quote('jextboxarticleautomanager'));
		$db->setQuery($query);
		if (!$db->loadResult()) {
			Joomla\CMS\Factory::getApplication()->enqueueMessage('"Content - JExtBOX Article Auto Manager" plugin is not installed.', 'error');
		} elseif (!Joomla\CMS\Plugin\PluginHelper::isEnabled('content', 'jextboxarticleautomanager')){
			Joomla\CMS\Factory::getApplication()->enqueueMessage('"Content - JExtBOX Article Auto Manager" plugin is not enabled.', 'warning');
		} else {
			$xml = simplexml_load_file(JPATH_PLUGINS.DIRECTORY_SEPARATOR.'content'.DIRECTORY_SEPARATOR.'jextboxarticleautomanager'.DIRECTORY_SEPARATOR.'jextboxarticleautomanager.xml');
			$type = $xml->xpath('//config/fields[@name="params"]/fieldset[@name="basic"]/field[@name="type"]');
			if ($type[0]['default'] != 'full'){
				Joomla\CMS\Factory::getApplication()->enqueueMessage('You are using the free version. Visit <a href="http://jextbox.com" target="_blank">www.JExtBOX.com</a> to buy the full version.', 'notice');
			}
		}

		$this->state = $this->get('State');
		$this->item = $this->get('Item');
		$this->form = $this->get('Form');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}

		$this->addToolbar();
		parent::display($tpl);

	}

	/**
	 * Add the page title and toolbar.
	 */
	protected function addToolbar()
	{
		Joomla\CMS\Factory::getApplication()->input->set('hidemainmenu', true);

		$user = version_compare(JVERSION, '5.0.0', '<') ? Joomla\CMS\Factory::getUser() : Joomla\CMS\Factory::getApplication()->getIdentity();
		$isNew = ($this->item->id == 0);
		if (isset($this->item->checked_out)) {
			$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $user->get('id'));
		} else {
			$checkedOut = false;
		}
		$canDo = JextboxarticleautomanagerHelper::getActions();

		JToolBarHelper::title(Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_TITLE_OPERATION').' - '.Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER'), 'cogs');

		// If not checked out, can save the item.
		if (!$checkedOut && ($canDo->get('core.edit') || ($canDo->get('core.create'))))
		{
			JToolBarHelper::apply('operation.apply', 'JTOOLBAR_APPLY');
			JToolBarHelper::save('operation.save', 'JTOOLBAR_SAVE');
		}
		if (!$checkedOut && ($canDo->get('core.create'))){
			JToolBarHelper::custom('operation.save2new', 'save-new.png', 'save-new_f2.png', 'JTOOLBAR_SAVE_AND_NEW', false);
		}
		// If an existing item, can save to a copy.
		if (!$isNew && $canDo->get('core.create')) {
			JToolBarHelper::custom('operation.save2copy', 'save-copy.png', 'save-copy_f2.png', 'JTOOLBAR_SAVE_AS_COPY', false);
		}
		if (empty($this->item->id)) {
			JToolBarHelper::cancel('operation.cancel', 'JTOOLBAR_CANCEL');
		}
		else {
			JToolBarHelper::cancel('operation.cancel', 'JTOOLBAR_CLOSE');
		}

	}
}

?>
