<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2024. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

Joomla\CMS\HTML\HTMLHelper::_('jquery.framework');

Joomla\CMS\HTML\HTMLHelper::addIncludePath(JPATH_COMPONENT.'/helpers/html');
if ($j3 = version_compare(JVERSION, '4.0.0', '<'))
{
	Joomla\CMS\HTML\HTMLHelper::_('bootstrap.tooltip', '.hasTooltip', ['placement' => 'auto-dir bottom-left']);
	Joomla\CMS\HTML\HTMLHelper::_('formbehavior.chosen', 'select');
}
Joomla\CMS\HTML\HTMLHelper::_('behavior.multiselect');

// Import CSS
$document = Joomla\CMS\Factory::getDocument();
$document->addStyleSheet('components/com_jextboxarticleautomanager/assets/css/jextboxarticleautomanager.css');

$user = version_compare(JVERSION, '5.0.0', '<') ? Joomla\CMS\Factory::getUser() : Joomla\CMS\Factory::getApplication()->getIdentity();
$userId = $user->get('id');
$listOrder = $this->state->get('list.ordering');
$listDirn = $this->state->get('list.direction');
$canOrder = $user->authorise('core.edit.state', 'com_jextboxarticleautomanager');
$saveOrder = $listOrder == 'a.ordering';
if ($saveOrder)
{
	$saveOrderingUrl = 'index.php?option=com_jextboxarticleautomanager&task=operations.saveOrderAjax&tmpl=component';
	Joomla\CMS\HTML\HTMLHelper::_('sortablelist.sortable', 'operationList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}
$sortFields = $this->getSortFields();
$operationFields = $this->getOperationFields();
?>
<script type="text/javascript">
	Joomla.orderTable = function() {
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>') {
			dirn = 'asc';
		} else {
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
</script>

<?php
//Joomla Component Creator code to allow adding non select list filters
if (!empty($this->extra_sidebar)) {
	$this->sidebar .= $this->extra_sidebar;
}
?>

<form action="<?php echo Joomla\CMS\Router\Route::_('index.php?option=com_jextboxarticleautomanager&view=operations'); ?>" method="post" name="adminForm" id="adminForm">
<?php if(!empty($this->sidebar)): ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
<?php else : ?>
	<div id="j-main-container">
<?php endif;?>
		<div id="filter-bar" class="mb-4 clearfix">
			<div class="filter-search btn-group pull-left float-start">
				<label for="filter_search" class="element-invisible"><?php echo Joomla\CMS\Language\Text::_('JSEARCH_FILTER');?></label>
				<input type="text" name="filter_search" id="filter_search" class="form-control" placeholder="<?php echo Joomla\CMS\Language\Text::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo Joomla\CMS\Language\Text::_('JSEARCH_FILTER'); ?>" />
			</div>
			<div class="btn-group pull-left float-start">
				<button class="btn hasTooltip" type="submit" title="<?php echo Joomla\CMS\Language\Text::_('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i></button>
				<button class="btn hasTooltip" type="button" title="<?php echo Joomla\CMS\Language\Text::_('JSEARCH_FILTER_CLEAR'); ?>" onclick="jQuery('#filter_search').val('');this.form.submit();"><i class="icon-remove"></i></button>
			</div>
			<?php if (!$j3) : ?>
				<div class="btn-group pull-left float-start mx-2">
					<label for="filter_published" class="element-invisible"><?php echo Joomla\CMS\Language\Text::_('JOPTION_SELECT_PUBLISHED');?></label>
					<select name="filter_published" id="filter_published" class="<?php echo $j3 ? 'input-medium' : 'form-select'; ?>" onchange="this.form.submit()">
						<option value=""><?php echo Joomla\CMS\Language\Text::_('JOPTION_SELECT_PUBLISHED');?></option>
						<?php echo Joomla\CMS\HTML\HTMLHelper::_('select.options', Joomla\CMS\HTML\HTMLHelper::_('jgrid.publishedOptions'), "value", "text", $this->state->get('filter.state'), true); ?>
					</select>
				</div>
				<div class="btn-group pull-left float-start">
					<label for="filter_operation" class="element-invisible"><?php echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_SIDEBAR_FILTER_SELECT_OPERATION');?></label>
					<select name="filter_operation" id="filter_operation" class="<?php echo $j3 ? 'input-medium' : 'form-select'; ?>" onchange="this.form.submit()">
						<option value=""><?php echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_SIDEBAR_FILTER_SELECT_OPERATION');?></option>
						<?php echo Joomla\CMS\HTML\HTMLHelper::_('select.options', $operationFields, "value", "text", $this->state->get('filter.operation'), true); ?>
					</select>
				</div>
			<?php endif; ?>
			<div class="btn-group pull-right float-end">
				<label for="limit" class="element-invisible"><?php echo Joomla\CMS\Language\Text::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
				<?php echo $this->pagination->getLimitBox(); ?>
			</div>
			<div class="btn-group pull-right float-end mx-2">
				<label for="directionTable" class="element-invisible"><?php echo Joomla\CMS\Language\Text::_('JFIELD_ORDERING_DESC');?></label>
				<select name="directionTable" id="directionTable" class="<?php echo $j3 ? 'input-medium' : 'form-select'; ?>" onchange="Joomla.orderTable()">
					<option value=""><?php echo Joomla\CMS\Language\Text::_('JFIELD_ORDERING_DESC');?></option>
					<option value="asc" <?php if ($listDirn == 'asc') echo 'selected="selected"'; ?>><?php echo Joomla\CMS\Language\Text::_('JGLOBAL_ORDER_ASCENDING');?></option>
					<option value="desc" <?php if ($listDirn == 'desc') echo 'selected="selected"'; ?>><?php echo Joomla\CMS\Language\Text::_('JGLOBAL_ORDER_DESCENDING');?></option>
				</select>
			</div>
			<div class="btn-group pull-right float-end">
				<label for="sortTable" class="element-invisible"><?php echo Joomla\CMS\Language\Text::_('JGLOBAL_SORT_BY');?></label>
				<select name="sortTable" id="sortTable" class="<?php echo $j3 ? 'input-medium' : 'form-select'; ?>" onchange="Joomla.orderTable()">
					<option value=""><?php echo Joomla\CMS\Language\Text::_('JGLOBAL_SORT_BY');?></option>
					<?php echo Joomla\CMS\HTML\HTMLHelper::_('select.options', $sortFields, 'value', 'text', $listOrder);?>
				</select>
			</div>
		</div>
		<div class="clearfix"> </div>
		<table class="table table-striped" id="operationList">
			<thead>
				<tr>
					<?php if (isset($this->items[0]->ordering)): ?>
					<th width="1%" class="nowrap center hidden-phone">
						<?php echo Joomla\CMS\HTML\HTMLHelper::_('grid.sort', '<i class="icon-menu-2"></i>', 'a.ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING'); ?>
					</th>
					<?php endif; ?>
					<th width="1%" class="hidden-phone">
						<input type="checkbox" name="checkall-toggle" value="" title="<?php echo Joomla\CMS\Language\Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
					</th>
					<?php if (isset($this->items[0]->state)): ?>
					<th width="1%" class="nowrap center">
						<?php echo Joomla\CMS\HTML\HTMLHelper::_('grid.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
					</th>
					<?php endif; ?>
					<th class='left'>
						<?php echo Joomla\CMS\HTML\HTMLHelper::_('grid.sort', 'COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_NAME', 'a.name', $listDirn, $listOrder); ?>
					</th>
					<th class='left'>
						<?php echo Joomla\CMS\HTML\HTMLHelper::_('grid.sort', 'COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_OPERATION', 'a.operation', $listDirn, $listOrder); ?>
					</th>
					<th class='left'>
						<?php echo Joomla\CMS\HTML\HTMLHelper::_('grid.sort', 'COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_EXECUTION_PERIOD', 'a.execution_period', $listDirn, $listOrder); ?>
					</th>
					<th class='left'>
						<?php echo Joomla\CMS\HTML\HTMLHelper::_('grid.sort', 'COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_LAST_EXECUTE', 'a.last_execute', $listDirn, $listOrder); ?>
					</th>
					<th class='left'>
						<?php echo Joomla\CMS\HTML\HTMLHelper::_('grid.sort', 'COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_CREATED_BY', 'a.created_by', $listDirn, $listOrder); ?>
					</th>
					<?php if (isset($this->items[0]->id)): ?>
					<th width="1%" class="nowrap center hidden-phone">
						<?php echo Joomla\CMS\HTML\HTMLHelper::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
					</th>
					<?php endif; ?>
				</tr>
			</thead>
			<tfoot>
				<?php 
				if (isset($this->items[0])) {
					$colspan = count(get_object_vars($this->items[0]));
				} else {
					$colspan = 10;
				}
				?>
				<tr>
					<td colspan="<?php echo $colspan ?>">
						<?php echo $this->pagination->getListFooter(); ?>
					</td>
				</tr>
			</tfoot>
			<tbody>
				<?php foreach ($this->items as $i => $item) :
					$ordering = ($listOrder == 'a.ordering');
					$canCreate = $user->authorise('core.create', 'com_jextboxarticleautomanager');
					$canEdit = $user->authorise('core.edit', 'com_jextboxarticleautomanager');
					$canCheckin = $user->authorise('core.manage', 'com_jextboxarticleautomanager');
					$canChange = $user->authorise('core.edit.state', 'com_jextboxarticleautomanager');
				?>
					<tr class="row<?php echo $i % 2; ?>">
						<?php if (isset($this->items[0]->ordering)) : ?>
							<td class="order nowrap center hidden-phone">
								<?php if ($canChange) :
									$disableClassName = '';
									$disabledLabel = '';
									if (!$saveOrder) :
										$disabledLabel = Joomla\CMS\Language\Text::_('JORDERINGDISABLED');
										$disableClassName = 'inactive tip-top';
									endif; ?>
									<span class="sortable-handler hasTooltip <?php echo $disableClassName?>" title="<?php echo $disabledLabel?>">
										<i class="icon-menu"></i>
									</span>
									<input type="text" style="display:none" name="order[]" size="5" value="<?php echo $item->ordering;?>" class="width-20 text-area-order " />
								<?php else : ?>
									<span class="sortable-handler inactive" >
										<i class="icon-menu"></i>
									</span>
								<?php endif; ?>
							</td>
						<?php endif; ?>
						<td class="center hidden-phone">
							<?php echo Joomla\CMS\HTML\HTMLHelper::_('grid.id', $i, $item->id); ?>
						</td>
						<?php if (isset($this->items[0]->state)): ?>
							<td class="center">
								<?php echo Joomla\CMS\HTML\HTMLHelper::_('jgrid.published', $item->state, $i, 'operations.', $canChange, 'cb'); ?>
							</td>
						<?php endif; ?>
						<td>
							<?php if (isset($item->checked_out) && $item->checked_out) : ?>
								<?php echo Joomla\CMS\HTML\HTMLHelper::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'operations.', $canCheckin); ?>
							<?php endif; ?>
							<?php if ($canEdit) : ?>
								<a href="<?php echo Joomla\CMS\Router\Route::_('index.php?option=com_jextboxarticleautomanager&task=operation.edit&id='.(int) $item->id); ?>">
								<?php echo $this->escape($item->name); ?></a>
							<?php else : ?>
								<?php echo $this->escape($item->name); ?>
							<?php endif; ?>
						</td>
						<td>
							<?php
								switch ($item->operation) {
									case 1:
										echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_OPTION_CHANGE_STATE');
										break;
									case 2:
										echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_OPTION_MODIFY_FEATURED_STATUS');
										break;
									case 3:
										echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_OPTION_MOVE_TO_ANOTHER_CATEGORY');
										break;
									case 4:
										echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_OPTION_CHANGE_ACCESS_LEVEL');
										break;
									case 5:
										echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_OPTION_EXTEND_PUBLISH_DOWN');
										break;
								}
							?>
						</td>
						<td>
							<?php
								switch ($item->execution_period) {
									case 1:
										echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_EXECUTION_PERIOD_EVERY_DAY');
										break;
									case 2:
										echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_EXECUTION_PERIOD_EVERY_WEEK');
										break;
									case 3:
										echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_EXECUTION_PERIOD_EVERY_MONTH');
										break;
									case 4:
										echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_EXECUTION_PERIOD_EVERY_YEAR');
										break;
								}
							?>
						</td>
						<td>
							<?php
								if($item->last_execute == '0000-00-00 00:00:00' || is_null($item->last_execute)){
									echo Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_LAST_EXECUTE_NEVER');
								}else{
									$last_execute = Joomla\CMS\Date\Date::getInstance($item->last_execute);
									$config = new JConfig;
									$last_execute->setTimezone(new DateTimeZone($config->offset));
									unset($config);
									echo $last_execute->__toString();
									unset($last_execute);
								}
							?>
						</td>
						<td>
							<?php echo $item->created_by; ?>
						</td>
						<?php if (isset($this->items[0]->id)): ?>
							<td class="center hidden-phone">
								<?php echo (int) $item->id; ?>
							</td>
						<?php endif; ?>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<?php echo Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
		<div class="text-center">
			Copyright (C) 2011-2024 <a href="https://www.galaa.net" target="_blank">Galaa</a>. Distributed by <a href="https://www.jextbox.com" target="_blank">JExtBOX - BOX of Joomla Extensions</a>
		</div>
	</div>
</form>
