<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2023. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * View class for a list of Jextboxarticleautomanager.
 */
class JextboxarticleautomanagerViewOperations extends Joomla\CMS\MVC\View\HtmlView
{

	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */

	public function display($tpl = null)
	{

		$db = Joomla\CMS\Factory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select('COUNT(*)')
			->from($db->quoteName('#__extensions'))
			->where($db->quoteName('element')." = ".$db->quote('jextboxarticleautomanager'));
		$db->setQuery($query);
		if (!$db->loadResult()) {
			Joomla\CMS\Factory::getApplication()->enqueueMessage('"Content - JExtBOX Article Auto Manager" plugin is not installed.', 'error');
		} elseif (!Joomla\CMS\Plugin\PluginHelper::isEnabled('content', 'jextboxarticleautomanager')){
			Joomla\CMS\Factory::getApplication()->enqueueMessage('"Content - JExtBOX Article Auto Manager" plugin is not enabled.', 'warning');
		} else {
			$xml = simplexml_load_file(JPATH_PLUGINS.DIRECTORY_SEPARATOR.'content'.DIRECTORY_SEPARATOR.'jextboxarticleautomanager'.DIRECTORY_SEPARATOR.'jextboxarticleautomanager.xml');
			$type = $xml->xpath('//config/fields[@name="params"]/fieldset[@name="basic"]/field[@name="type"]');
			if($type[0]['default'] != 'full'){
				Joomla\CMS\Factory::getApplication()->enqueueMessage('You are using the free version. Visit <a href="https://www.jextbox.com" target="_blank">www.JExtBOX.com</a> to buy the full version.', 'notice');
			}
		}

		$this->state = $this->get('State');
		$this->items = $this->get('Items');
		$this->pagination = $this->get('Pagination');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}

		$this->addToolbar();

		if (version_compare(JVERSION, '4.0.0', '<'))
		{
			JextboxarticleautomanagerHelper::addSubmenu('operations');
			$this->sidebar = JHtmlSidebar::render();
		}

		parent::display($tpl);

	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */

	protected function addToolbar()
	{

		require_once JPATH_COMPONENT.'/helpers/jextboxarticleautomanager.php';

		$state = $this->get('State');
		$canDo = JextboxarticleautomanagerHelper::getActions();

		JToolBarHelper::title(Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_TITLE_OPERATIONS').' - '.Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER'), 'list');

		//Check if the form exists before showing the add/edit buttons
		$formPath = JPATH_COMPONENT_ADMINISTRATOR.'/views/operation';
		if (file_exists($formPath)) {
			if ($canDo->get('core.create')) {
				JToolBarHelper::addNew('operation.add','JTOOLBAR_NEW');
			}
			if ($canDo->get('core.edit') && isset($this->items[0])) {
				JToolBarHelper::editList('operation.edit','JTOOLBAR_EDIT');
			}
		}

		if ($canDo->get('core.edit.state')) {
			if (isset($this->items[0]->state)) {
				JToolBarHelper::divider();
				JToolBarHelper::custom('operations.publish', 'publish.png', 'publish_f2.png','JTOOLBAR_PUBLISH', true);
				JToolBarHelper::custom('operations.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
			} else if (isset($this->items[0])) {
				//If this component does not use state then show a direct delete button as we can not trash
				JToolBarHelper::deleteList('', 'operations.delete','JTOOLBAR_DELETE');
			}

			if (isset($this->items[0]->state)) {
				JToolBarHelper::divider();
				JToolBarHelper::archiveList('operations.archive','JTOOLBAR_ARCHIVE');
			}
			if (isset($this->items[0]->checked_out)) {
				JToolBarHelper::custom('operations.checkin', 'checkin.png', 'checkin_f2.png', 'JTOOLBAR_CHECKIN', true);
			}
		}

		//Show trash and delete for components that uses the state field
		if (isset($this->items[0]->state)) {
			if ($state->get('filter.state') == -2 && $canDo->get('core.delete')) {
				JToolBarHelper::deleteList('JGLOBAL_CONFIRM_DELETE', 'operations.delete','JTOOLBAR_EMPTY_TRASH');
				JToolBarHelper::divider();
			} else if ($canDo->get('core.edit.state')) {
				JToolBarHelper::trash('operations.trash','JTOOLBAR_TRASH');
				JToolBarHelper::divider();
			}
		}

		//Set sidebar action - New in 3.0
		if (version_compare(JVERSION, '4.0.0', '<')) {
			JHtmlSidebar::setAction('index.php?option=com_jextboxarticleautomanager&view=operations');
		} else {
			Joomla\CMS\HTML\Helpers\Sidebar::setAction('index.php?option=com_jextboxarticleautomanager&view=operations');
		}
		$this->extra_sidebar = '';

		if (version_compare(JVERSION, '4.0.0', '<')) {
			JHtmlSidebar::addFilter(
				JText::_('JOPTION_SELECT_PUBLISHED'),
				'filter_published',
				JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.state'), true)
			);
		} else {
			Joomla\CMS\HTML\Helpers\Sidebar::addFilter(
				Joomla\CMS\Language\Text::_('JOPTION_SELECT_PUBLISHED'),
				'filter_published',
				Joomla\CMS\HTML\HTMLHelper::_('select.options', Joomla\CMS\HTML\HTMLHelper::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.state'), true)
			);
		}

		//Filter for the field method
		$select_label = Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_SIDEBAR_FILTER_SELECT_OPERATION');
		$options = $this->getOperationFields();
		if (version_compare(JVERSION, '4.0.0', '<')) {
			JHtmlSidebar::addFilter(
				$select_label,
				'filter_operation',
				JHtml::_('select.options', $options , "value", "text", $this->state->get('filter.operation'), true)
			);
		} else {
			Joomla\CMS\HTML\Helpers\Sidebar::addFilter(
				$select_label,
				'filter_operation',
				Joomla\CMS\HTML\HTMLHelper::_('select.options', $options , 'value', 'text', $this->state->get('filter.operation'), true)
			);
		}

		if($canDo->get('custom.execute.operation') && isset($this->items[0])){
			JToolBarHelper::custom('operations.execute_operation', 'play', '', 'COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_MANUAL_EXECUTION_BUTTON', true);
		}

		if($canDo->get('custom.reset.last.executed') && isset($this->items[0])){
			JToolBarHelper::custom('operations.reset_last_executed', 'undo-2', '', 'COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_RESET_LAST_EXECUTED_BUTTON', true);
		}

		if ($canDo->get('core.admin')) {
			JToolBarHelper::preferences('com_jextboxarticleautomanager');
		}

	}

	protected function getOperationFields()
	{

		$options = array();
		$options[0] = new stdClass();
		$options[0]->value = "1";
		$options[0]->text = Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_SIDEBAR_FILTER_OPTION_CHANGE_STATE');
		$options[1] = new stdClass();
		$options[1]->value = "2";
		$options[1]->text = Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_SIDEBAR_FILTER_OPTION_MODIFY_FEATURED_STATUS');
		$options[2] = new stdClass();
		$options[2]->value = "3";
		$options[2]->text = Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_SIDEBAR_FILTER_OPTION_MOVE_TO_ANOTHER_CATEGORY');
		$options[3] = new stdClass();
		$options[3]->value = "4";
		$options[3]->text = Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_SIDEBAR_FILTER_OPTION_CHANGE_ACCESS_LEVEL');
		return $options;

	}

	protected function getSortFields()
	{

		return array(
			'a.id' => Joomla\CMS\Language\Text::_('JGRID_HEADING_ID'),
			'a.name' => Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_NAME'),
			'a.ordering' => Joomla\CMS\Language\Text::_('JGRID_HEADING_ORDERING'),
			'a.state' => Joomla\CMS\Language\Text::_('JSTATUS'),
			'a.operation' => Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_OPERATION'),
			'a.execution_period' => Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_EXECUTION_PERIOD'),
			'a.last_execute' => Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_LAST_EXECUTE'),
			'a.created_by' => Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_CREATED_BY'),
			'a.checked_out' => Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_CHECKED_OUT'),
			'a.checked_out_time' => Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_CHECKED_OUT_TIME'),
		);

	}

}
