<?php

/**
 * @version     2.0.0
 * @package     com_draughts
 * @copyright   Copyright (C) 2015. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Galaa <contact@galaa.mn> - http://galaa.mn
 */
// No direct access
defined('_JEXEC') or die;

/**
 * Draughts helper.
 */
class DraughtsHelper {

    /**
     * Configure the Linkbar.
     */
    public static function addSubmenu($vName = '') {
        		JHtmlSidebar::addEntry(
			JText::_('COM_DRAUGHTS_TITLE_GAMES'),
			'index.php?option=com_draughts&view=games',
			$vName == 'games'
		);
		JHtmlSidebar::addEntry(
			JText::_('JCATEGORIES') . ' (' . JText::_('COM_DRAUGHTS_TITLE_GAMES') . ')',
			"index.php?option=com_categories&extension=com_draughts",
			$vName == 'categories'
		);
		if ($vName=='categories') {
			JToolBarHelper::title('Draughts: JCATEGORIES (COM_DRAUGHTS_TITLE_GAMES)');
		}

    }

    /**
     * Gets a list of the actions that can be performed.
     *
     * @return	JObject
     * @since	1.6
     */
    public static function getActions() {
        $user = JFactory::getUser();
        $result = new JObject;

        $assetName = 'com_draughts';

        $actions = array(
            'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
        );

        foreach ($actions as $action) {
            $result->set($action, $user->authorise($action, $assetName));
        }

        return $result;
    }


}
