<?php
/*
 * @version     2.0.0
 * @package     com_draughts
 * @copyright   Copyright (C) 2015. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Galaa <contact@galaa.mn> - http://galaa.mn
 */

// no direct access
defined('_JEXEC') or die;

?>
<?php if (!$this->item) {
	echo JText::_('COM_DRAUGHTS_ITEM_NOT_LOADED');
} elseif(!$this->item->permission) { ?>
<div id="system-message-container">
	<div id="system-message">
		<div class="alert alert-warning">
			<a class="close" data-dismiss="alert">×</a>
			<h4 class="alert-heading"><?php echo JText::_('COM_DRAUGHTS_WARNING'); ?></h4>
			<div>
				<p><?php echo JText::_('COM_DRAUGHTS_PERMISSION_DENIED'); ?></p>
			</div>
		</div>
	</div>
</div>
<?php } else { ?>
<div class="item-page">
	<div class="page-header">
		<h2>
			<a href="<?php echo JRoute::_('index.php?option=com_draughts&view=game&id='.(int) $this->item->id); ?>">
				<?php echo $this->escape($this->item->title); ?>
			</a>
		</h2>
	</div>
	<div>
		<dl class="article-info muted">
			<dt class="article-info-term"><?php echo JText::_('COM_DRAUGHTS_FORM_LBL_GAME_DETAILS'); ?></dt>
			<dd class="createdby"><?php echo JText::_('COM_DRAUGHTS_FORM_LBL_GAME_CREATED_BY'); ?>: <?php echo $this->item->created_by_name; ?></dd>
			<dd class="category-name"><?php echo JText::_('COM_DRAUGHTS_FORM_LBL_GAME_CATEGORY'); ?>: <?php echo $this->item->category_title; ?></dd>
			<?php if($this->item->tag) { ?>
			<dd class="tag"><?php echo JText::_('COM_DRAUGHTS_FORM_LBL_GAME_TAG'); ?>: <?php echo $this->item->tag; ?></dd>
			<?php } ?>
		</dl>
	</div>
	<div>
		<div class="draugths-responsive">
			<div class="draugths">
				<iframe src="components/com_draughts/draughts/draughts.php?position=<?php echo $this->item->position; ?>&moves=<?php echo $this->item->movement; ?>&speed=<?php echo $this->item->speed; ?>" width="350" height="350" frameborder="0" scrolling="no" seamless="seamless">
					<p>Your browser does not support iframes.</p>
				</iframe>
			</div>
		</div>
		<br>
		<p>
			<?php if($this->item->white_player_name) { ?>&#9920; <?php echo $this->item->white_player_name; ?> <?php } ?>
			<?php if($this->item->black_player_name) { ?>&#9922; <?php echo $this->item->black_player_name; ?> <?php } ?>
			<?php if($this->item->winner) { ?>&#9872; <?php echo $this->item->winner; ?> <?php } ?>
		</p>
		<p>
			<?php if($this->item->game_date) { ?><span class="icon-calendar"></span> <?php echo $this->item->game_date; } ?> <?php if($this->item->game_place) { ?><span class="icon-home"></span> <?php echo $this->item->game_place; } ?>
		</p>
		<?php if(!empty($this->item->position)) { ?>
		<p><strong><?php echo JText::_('COM_DRAUGHTS_FORM_LBL_GAME_POSITION'); ?></strong></p>
		<p><?php echo $this->item->position_f; ?></p>
		<?php } ?>
		<?php if(!empty($this->item->movement)) { ?>
		<p><strong><?php echo JText::_('COM_DRAUGHTS_FORM_LBL_GAME_MOVEMENT'); ?></strong></p>
		<p><?php echo $this->item->movement_f; ?></p>
		<?php } ?>
		<?php if(!empty($this->item->description)) { ?>
		<p><strong><?php echo JText::_('COM_DRAUGHTS_FORM_LBL_GAME_DESCRIPTION'); ?></strong></p>
		<?php echo $this->item->description; ?>
		<?php } ?>
	</div>
</div>
<?php } ?>
