<?php
/**
 * @version     2.0.0
 * @package     com_draughts
 * @copyright   Copyright (C) 2015. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Galaa <contact@galaa.mn> - http://galaa.mn
 */
// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user = JFactory::getUser();
$userId = $user->get('id');
$listOrder = $this->state->get('list.ordering');
$listDirn = $this->state->get('list.direction');

// Default Parameter Values
$viewtype = 'list';
$show_category = 1;
$show_tag = 1;
$show_date_and_place = 1;
$players_and_winner = 1;
$description = 1;
$description_limit = 50;
$show_board = 0;

// Load Parameter Values
$input = JFactory::getApplication()->input;
$menuitemid = $input->getInt( 'Itemid' );  // this returns the menu id number so you can reference parameters
$menu = new JApplicationSite;
$menu = $menu->getMenu();
if ($menuitemid) {
	$menuparams = $menu->getParams( $menuitemid );
	if($menuparams->get('viewtype', 1))
	{
		$viewtype = 'blog';
		$show_board = $menuparams->get('show_board', 1);
	}
	$show_category = $menuparams->get('show_category', 1);
	$show_tag = $menuparams->get('show_tag', 1);
	$show_date_and_place = $menuparams->get('show_date-and-place', 1);
	$show_players_and_winner = $menuparams->get('show_players-and-winner', 1);
	$show_description = $menuparams->get('show_description', 1);
	$description_limit = $menuparams->get('description-limit', 50);
}

?>

<form action="<?php echo JRoute::_('index.php?option=com_draughts&view=games'); ?>" method="post" name="adminForm" id="adminForm">

	<?php echo JLayoutHelper::render('default_filter', array('view' => $this), dirname(__FILE__)); ?>
	<?php if($viewtype === 'list'): ?>
	<div class="table-responsive">
		<table class="table table-striped" id = "gameList" >
			<thead >
				<tr >
					<th class='left'>
					<?php echo JHtml::_('grid.sort',  'COM_DRAUGHTS_GAMES_TITLE', 'a.title', $listDirn, $listOrder); ?>
					</th>
					<?php if($show_category): ?>
					<th class='left'>
					<?php echo JHtml::_('grid.sort',  'COM_DRAUGHTS_GAMES_CATEGORY', 'a.category', $listDirn, $listOrder); ?>
					</th>
					<?php endif; ?>
					<?php if($show_tag): ?>
					<th class='left'>
					<?php echo JHtml::_('grid.sort',  'COM_DRAUGHTS_GAMES_TAG', 'a.tag', $listDirn, $listOrder); ?>
					</th>
					<?php endif; ?>
					<?php if($show_date_and_place): ?>
					<th class='left'>
					<?php echo JHtml::_('grid.sort',  'COM_DRAUGHTS_GAMES_GAME_DATE', 'a.game_date', $listDirn, $listOrder); ?>
					</th>
					<th class='left'>
					<?php echo JHtml::_('grid.sort',  'COM_DRAUGHTS_GAMES_GAME_PLACE', 'a.game_place', $listDirn, $listOrder); ?>
					</th>
					<?php endif; ?>
					<?php if($show_players_and_winner): ?>
					<th class='left'>
					<?php echo JHtml::_('grid.sort',  'COM_DRAUGHTS_GAMES_WHITE_PLAYER_NAME', 'a.white_player_name', $listDirn, $listOrder); ?>
					</th>
					<th class='left'>
					<?php echo JHtml::_('grid.sort',  'COM_DRAUGHTS_GAMES_BLACK_PLAYER_NAME', 'a.black_player_name', $listDirn, $listOrder); ?>
					</th>
					<th class='left'>
					<?php echo JHtml::_('grid.sort',  'COM_DRAUGHTS_GAMES_WINNER', 'a.winner', $listDirn, $listOrder); ?>
					</th>
					<?php endif; ?>
					<?php if($show_description): ?>
					<th class='left'>
					<?php echo JHtml::_('grid.sort',  'COM_DRAUGHTS_GAMES_DESCRIPTION', 'a.description', $listDirn, $listOrder); ?>
					</th>
					<?php endif; ?>
				</tr>
			</thead>
			<tbody>
			<?php foreach ($this->items as $i => $item) : ?>
				<tr class="row<?php echo $i % 2; ?>">
					<td>
						<a href="<?php echo JRoute::_('index.php?option=com_draughts&view=game&id='.(int) $item->id); ?>">
						<?php echo $this->escape($item->title); ?></a>
					</td>
					<?php if($show_category): ?>
					<td>
						<?php echo $item->category; ?>
					</td>
					<?php endif; ?>
					<?php if($show_tag): ?>
					<td>
						<?php echo $item->tag; ?>
					</td>
					<?php endif; ?>
					<?php if($show_date_and_place): ?>
					<td>
						<?php echo $item->game_date; ?>
					</td>
					<td>
						<?php echo $item->game_place; ?>
					</td>
					<?php endif; ?>
					<?php if($show_players_and_winner): ?>
					<td>
						<?php echo $item->white_player_name; ?>
					</td>
					<td>
						<?php echo $item->black_player_name; ?>
					</td>
					<td>
						<?php echo $item->winner; ?>
					</td>
					<?php endif; ?>
					<?php if($show_description): ?>
					<td>
						<?php echo ($description_limit > 0 ? mb_substr(strip_tags($item->description), 0, $description_limit) : $item->description); ?>
					</td>
					<?php endif; ?>
				</tr>
			<?php endforeach; ?>
			</tbody>
		</table>
	</div>
	<?php else: // Blog Layout ?>
	<div class="blog">
		<?php foreach ($this->items as $i => $item) : ?>
		<div class="items-leading clearfix">
			<div class="leading-0">
				<div class="page-header">
					<h2><a href="<?php echo JRoute::_('index.php?option=com_draughts&view=game&id='.(int) $item->id); ?>">
					<?php echo $this->escape($item->title); ?></a></h2>
				</div>
				<?php if($show_category || $show_tag): ?>
				<dl class="article-info muted">
					<dt class="article-info-term"><?php echo JText::_('COM_DRAUGHTS_GAMES_DETAILS'); ?></dt>
					<?php if($show_category): ?>
					<dd class="category-name"><?php echo JText::_('COM_DRAUGHTS_GAMES_CATEGORY'); ?>: <?php echo $item->category; ?></dd>
					<?php endif; ?>
					<?php if($show_tag && $item->tag): ?>
					<dd class="tag"><?php echo JText::_('COM_DRAUGHTS_GAMES_TAG'); ?>: <?php echo $item->tag; ?></dd>
					<?php endif; ?>
				</dl>
				<?php endif; ?>
				<?php if($show_board): ?>
				<div class="draugths-responsive">
					<div class="draugths">
						<iframe src="components/com_draughts/draughts/draughts.php?position=<?php echo $item->position; ?>&moves=<?php echo $item->movement; ?>&speed=<?php echo $item->speed; ?>" width="350" height="350" frameborder="0" scrolling="no" seamless="seamless">
							<p>Your browser does not support iframes.</p>
						</iframe>
					</div>
				</div>
				<br>
				<?php endif; ?>
				<?php if($show_players_and_winner): ?>
				<p>
					<?php if($item->white_player_name): ?>&#9920; <?php echo $item->white_player_name; ?> <?php endif; ?>
					<?php if($item->black_player_name): ?>&#9922; <?php echo $item->black_player_name; ?> <?php endif; ?>
					<?php if($item->winner): ?>&#9872; <?php echo $item->winner; ?> <?php endif; ?>
				</p>
				<?php endif; ?>
				<?php if($show_date_and_place): ?>
				<p>
					<?php if($item->game_date !== '0000-00-00'): ?><span class="icon-calendar"></span> <?php echo $item->game_date; ?> <?php endif; if($item->game_place): ?><span class="icon-home"></span> <?php echo $item->game_place; endif; ?>
				</p>
				<?php endif; ?>
				<?php if($show_description): ?>
					<?php echo ($description_limit > 0 ? '<p>'.mb_substr(strip_tags($item->description), 0, $description_limit).'</p>' : $item->description); ?>
				<?php endif; ?>
				<p class="readmore">
					<a class="btn" href="<?php echo JRoute::_('index.php?option=com_draughts&view=game&id='.(int) $item->id); ?>"><span class="icon-chevron-right"></span>Read more: <?php echo $this->escape($item->title); ?></a>
				</p>
			</div>
		</div>
		<?php endforeach; ?>
	</div>
	<?php endif;?>

	<?php echo $this->pagination->getListFooter(); ?>

    <input type="hidden" name="task" value=""/>
    <input type="hidden" name="boxchecked" value="0"/>
    <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>"/>
    <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>"/>
    <?php echo JHtml::_('form.token'); ?>
</form>
