<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * @extension     Draughts
 * @author        Galaa
 * @authorUrl     www.galaa.mn
 * @authorEmail   contact@galaa.mn
 * @publisher     JExtBOX - BOX of Joomla Extensions
 * @publisherURL  www.jextbox.com
 * @copyright     Copyright (C) 2011-2015 Galaa
 * @license       This extension in released under the GNU/GPL License - http://www.gnu.org/copyleft/gpl.html
 * 
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// No direct access
defined('_JEXEC') or die;

// Import library dependencies
jimport('joomla.plugin.plugin');

class plgContentDraughts extends JPlugin
{

	/**
	 * @param	string	The context of the content being passed to the plugin.
	 * @param	object	The content object.  Note $article->text is also available
	 * @param	object	The content params
	 * @param	int	The 'page' number
	 * @since	1.6
	 */
	function onContentPrepare($context, &$article, &$params, $page = 0)
	{

		if(!preg_match_all('/\[draughts\]([wbpk,:0-9]+;?m?:?[0-9,-]*)\[\/draughts\]/i', $article->text, $draughtsscripts)):
			return;
		endif;
		$component_params = JComponentHelper::getParams('com_draughts');
		$speed = $component_params->get('speed');
		foreach($draughtsscripts[1] as $key => $draughtsscript):
			$draughtsscript = strtolower($draughtsscript);
			$draughtsscript = explode(';m:', $draughtsscript);
			$draughtsscript = '<div class="draugths-responsive"><div class="draugths">
				<iframe src="components/com_draughts/draughts/draughts.php?position='.$draughtsscript[0].'&moves='.(isset($draughtsscript[1]) ? $draughtsscript[1] : '').'&speed='.$speed.'" width="350" height="350" frameborder="0" scrolling="no" seamless="seamless"><p>Your browser does not support iframes.</p></iframe></div></div>';
			$article->text = str_replace($draughtsscripts[0][$key], $draughtsscript, $article->text);
		endforeach;
		$doc = JFactory::getDocument();
		$doc->addStyleSheet('plugins/content/draughts/assets/css/draugths.css');

	} // onPrepareContent

} // class

?>
